/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.exposure.world.level.storage;

import com.google.common.base.Preconditions;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraft.class_1297;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3544;
import net.minecraft.class_9139;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExposureIdentifier {
    public static final ExposureIdentifier EMPTY = new ExposureIdentifier("", null);
    public static final Codec<ExposureIdentifier> CODEC = new Codec<ExposureIdentifier>(){

        public <T> DataResult<T> encode(ExposureIdentifier input, DynamicOps<T> ops, T prefix) {
            if (input.isEmpty()) {
                return DataResult.success((Object)ops.createString(""));
            }
            return input.map(id -> SIMPLE_ID_CODEC, texture -> FULL_CODEC).encode((Object)input, ops, prefix);
        }

        public <T> DataResult<Pair<ExposureIdentifier, T>> decode(DynamicOps<T> ops, T input) {
            DataResult simpleResult = SIMPLE_ID_CODEC.decode(ops, input);
            if (simpleResult.error().isPresent()) {
                return FULL_CODEC.decode(ops, input);
            }
            return simpleResult;
        }
    };
    public static final Codec<ExposureIdentifier> SIMPLE_ID_CODEC = Codec.STRING.flatComapMap(ExposureIdentifier::id, identifier -> identifier.id != null ? DataResult.success((Object)identifier.id) : DataResult.error(() -> "Cannot serialize to string: id is null."));
    public static final Codec<ExposureIdentifier> FULL_CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.STRING.optionalFieldOf("id").forGetter(ei -> Optional.ofNullable(ei.id)), (App)class_2960.field_25139.optionalFieldOf("texture").forGetter(ei -> Optional.ofNullable(ei.texture))).apply((Applicative)instance, (idOpt, textureOpt) -> new ExposureIdentifier(idOpt.orElse(null), textureOpt.orElse(null))));
    public static final class_9139<class_2540, ExposureIdentifier> STREAM_CODEC = new class_9139<class_2540, ExposureIdentifier>(){

        @NotNull
        public ExposureIdentifier decode(class_2540 buffer) {
            boolean isTexture = buffer.readBoolean();
            return isTexture ? ExposureIdentifier.texture(buffer.method_10810()) : ExposureIdentifier.id(buffer.method_19772());
        }

        public void encode(class_2540 buffer, ExposureIdentifier instance) {
            buffer.method_52964(instance.isTexture());
            instance.ifId(arg_0 -> ((class_2540)buffer).method_10814(arg_0)).ifTexture(arg_0 -> ((class_2540)buffer).method_10812(arg_0));
        }
    };
    @Nullable
    private final String id;
    @Nullable
    private final class_2960 texture;

    private ExposureIdentifier(@Nullable String id, @Nullable class_2960 texture) {
        Preconditions.checkArgument((id == null || texture == null ? 1 : 0) != 0, (Object)"Cannot have both id and texture defined at once. Only one of them should be present.");
        this.id = id;
        this.texture = texture;
    }

    public static ExposureIdentifier id(@NotNull String id) {
        return new ExposureIdentifier(id, null);
    }

    public static ExposureIdentifier texture(@NotNull class_2960 texture) {
        return new ExposureIdentifier(null, texture);
    }

    public boolean isEmpty() {
        return this == EMPTY || this.id != null && this.id.isEmpty();
    }

    @Nullable
    public String id() {
        return this.id;
    }

    public Optional<String> getId() {
        return Optional.ofNullable(this.id);
    }

    @Nullable
    public class_2960 texture() {
        return this.texture;
    }

    public Optional<class_2960> getTexture() {
        return Optional.ofNullable(this.texture);
    }

    @Contract
    public boolean isId() {
        return this.id != null;
    }

    public boolean isTexture() {
        return this.texture != null;
    }

    public <T> T map(Function<String, T> ifId, Function<class_2960, T> ifTexture) {
        return this.isId() ? ifId.apply(this.id) : ifTexture.apply(this.texture());
    }

    public ExposureIdentifier ifId(Consumer<String> idConsumer) {
        if (this.isId()) {
            idConsumer.accept(this.id);
        }
        return this;
    }

    public <T> Optional<T> mapId(Function<String, T> mappingFunc) {
        return this.isId() ? Optional.of(mappingFunc.apply(this.id)) : Optional.empty();
    }

    public ExposureIdentifier ifTexture(Consumer<class_2960> textureConsumer) {
        if (this.isTexture()) {
            textureConsumer.accept(this.texture());
        }
        return this;
    }

    public <T> Optional<T> mapTexture(Function<class_2960, T> mappingFunc) {
        return this.isTexture() ? Optional.of(mappingFunc.apply(this.texture)) : Optional.empty();
    }

    public String toValueString() {
        return this.map(Function.identity(), class_2960::toString);
    }

    public String toString() {
        return this.isEmpty() ? "" : this.map(id -> "Id: " + id, texture -> "Texture: " + String.valueOf(texture));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ExposureIdentifier that = (ExposureIdentifier)o;
        return Objects.equals(this.id, that.id) && Objects.equals(this.texture, that.texture);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.texture);
    }

    public static String createId(class_1297 entity, String ... middleParts) {
        ArrayList<String> parts = new ArrayList<String>();
        parts.add(entity.method_5477().getString());
        parts.addAll(Arrays.asList(middleParts));
        parts.add(Long.toString(entity.method_37908().method_8510()));
        return ExposureIdentifier.createId((String[])parts.toArray(String[]::new));
    }

    public static String createId(String ... parts) {
        Preconditions.checkArgument((parts.length > 0 ? 1 : 0) != 0, (Object)"Cannot compose ID with 0 parts.");
        List<String> sanitizedParts = Arrays.stream(parts).filter(s -> !class_3544.method_15438((String)s)).map(s -> s.replaceAll("[^A-Za-z0-9-]", "-")).toList();
        return String.join((CharSequence)"_", sanitizedParts);
    }
}

